/***************************************************************************
 * Program: PWDUMP4 - dump winnt/2000 user/password hash remote or local for crack
 * 
 * Copyright (c) 2002, 2003 bingle, all rights reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author:  bingle@email.com.cn
 * File:    PipeInOut.cpp
 * Purpose: create or open named pipe for transfer data
 * Date:    2002-1-20
 * 
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <windows.h>
#include "Global.h"
#include "PipeInOut.h"

//_beginthreadex( NULL, 0, thBindPipe, NULL, 0, NULL);
unsigned __stdcall thBindPipe( void *param )
{
	BindParams *bind = (BindParams*) param;
	assert( param );
	return BindPipe( bind->pipe, bind->type, bind->phPipe );
}

#define DUMP_PIPE_SIZE 1024

/*
create a named pipe, and wait for client connected.
*/
int BindPipe( char *pipe, DWORD type, HANDLE *hPipe )
{
    char szPipeName[MAX_PATH];
	assert( pipe && hPipe && type );

    // Create the pipe
    _snprintf( szPipeName, sizeof (szPipeName), "\\\\.\\pipe\\%s", pipe );
    *hPipe = CreateNamedPipe( szPipeName,
                             PIPE_ACCESS_OUTBOUND | FILE_FLAG_WRITE_THROUGH,
                             type | PIPE_WAIT,
                             1, DUMP_PIPE_SIZE, DUMP_PIPE_SIZE, 10000, NULL);
    if( INVALID_HANDLE == *hPipe )
        return GetLastError();

    if( !ConnectNamedPipe(*hPipe, NULL) && GetLastError() != ERROR_PIPE_CONNECTED )
    {
        CloseHandle (*hPipe);
        return GetLastError();
    }

	return NO_ERROR;
}


void EndBindPipe( HANDLE hPipe )
{
	DisconnectNamedPipe (hPipe);
    CloseHandle (hPipe);
}


unsigned __stdcall thConnectPipe( void *param )
{
	ConnParams *conn = (ConnParams*) param;
	return ConnectPipe( conn->ip, conn->pipe, conn->func );
}

/*
open a remote pipe, use func to process the read data
*/
int ConnectPipe( char *ip, char *pipe, ProcessOutType func )
{
    HANDLE hPipe;
    CHAR szPipeName[MAX_PATH];

    _snprintf( szPipeName, sizeof (szPipeName), "\\\\%s\\pipe\\%s", ip, pipe );

    //
    // Open the output pipe
    //
	int timeout = 30000;
#ifdef _DEBUG
	//	timeout *= 10;
#endif
	DWORD start = GetTickCount();
	do{
		Sleep(10);
		hPipe = CreateFile (szPipeName, GENERIC_READ, 0, NULL, 
                        OPEN_EXISTING, FILE_FLAG_WRITE_THROUGH, NULL);
    if( hPipe != INVALID_HANDLE ) break;
    }while( (GetTickCount() - start) < timeout );
	
	if( hPipe == INVALID_HANDLE)
	{
		fprintf( stderr, "Failed to connect to pipe %s, error: %d\n",
                  szPipeName, GetLastError() );
		return 0;
	}
#ifdef _DEBUG
		fprintf( stderr, "pipe connected, wait result.\n" );
#endif

	char buff[DUMP_PIPE_SIZE+1];
	DWORD dwRead;
	do
	{
		if( ReadFile( hPipe, buff, sizeof(buff) - 1, &dwRead, NULL ) )
			func( buff, dwRead );
		else break;
	} while( 1 );//ERROR_BROKEN_PIPE );

	DWORD dwErr = GetLastError();
	if( dwErr != 109 && dwErr != 233 )
		fprintf( stderr, "\nRead Pipe error: %d\n", dwErr );

    CloseHandle (hPipe);
    return 0;
}
