/***************************************************************************
 * Program: PWDUMP4 - dump winnt/2000 user/password hash remote or local for crack
 * 
 * Copyright (c) 2002, 2003 bingle, all rights reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author:  bingle@email.com.cn
 * File:    Common.cpp
 * Purpose: some common support functions
 * Date:    2002-1-20
 * 
 ***************************************************************************/

#include <stdio.h>
#include <assert.h>
#include <windows.h>
#include <Ntsecapi.h>
#include "Global.h"

#ifdef _DEBUG
extern char szBuffer[1000];
void DebugOutput( char *lpFmt, ... )
{
	va_list	arglist;
	char *ptr = szBuffer + 4;

	assert( strlen(LSA_OUTPUT_TAG) == 4 && strlen(SRV_OUTPUT_TAG) == 4 );
	assert( memcmp(szBuffer, LSA_OUTPUT_TAG, 4) == 0 || memcmp( szBuffer, SRV_OUTPUT_TAG, 4) == 0 );

	va_start( arglist, lpFmt );
	_vsnprintf( ptr, sizeof(szBuffer)-4, lpFmt, arglist );
	va_end( arglist );
	
	OutputDebugString( szBuffer );
}
#endif

void obfuscate( unsigned* data, unsigned magic, unsigned count )
{
    unsigned i;
    for( i = 0; i < count; i++ )
    {
        unsigned carrybit = (magic & 0x00000001) ? 0x80000000 : 0;
        *data ^= magic;
        magic >>= 1;
        magic |= carrybit;
        data++;
    }
}

int SendText( char *lpFmt, ... );

// Try to enable the debug privilege
DWORD SetDebugPrivilege()
{
    HANDLE hToken = 0;
    DWORD dwError = 0;
    TOKEN_PRIVILEGES privileges;

    if( !OpenProcessToken( GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES, &hToken ) )
    {
        dwError = GetLastError();
        SendText( "Unable to open process token: %d\n", dwError );
        goto exit;
    }

    if( !LookupPrivilegeValue( NULL, SE_DEBUG_NAME, &privileges.Privileges[0].Luid ) )
    {
        dwError = GetLastError();
        SendText( "Unable to lookup privilege: %d\n", dwError );
        goto exit;
    }

    privileges.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
    privileges.PrivilegeCount = 1;
    
    if( !AdjustTokenPrivileges( hToken, FALSE, &privileges, 0, NULL, NULL ) )
    {
        dwError = GetLastError();
        SendText( "Unable to adjust token privileges: %d\n", dwError );
        goto exit;
    }

 exit:
    if( hToken ) CloseHandle( hToken );

    return dwError;
}

//get current execute program filename without extension part.
//ex: 'C:\Pwdump4.exe' will set 'Pwdump4' in name[] (at least MAX_PATH len)
void ExecuteMainName( char *exePath, char name[] )
{
	char *exeptr, *ptr;
	
	if(!exePath || !name) return;

	exeptr = strrchr( exePath, '\\' );
	if( exeptr ) exeptr++;
	else exeptr = exePath;
	
	ptr = strrchr(exeptr, '.');
	if(ptr) *ptr = 0;
	
	strcpy(name, exeptr);
}

//get current execute program filename without extension part.
//0 if ok
int ExecuteMainName( char name[] )
{
	char exePath[MAX_PATH];
	if( !GetModuleFileName( NULL, exePath, sizeof(exePath) ) )
		return GetLastError();
	
	ExecuteMainName(exePath, name);
	return NO_ERROR;
}

void ShowError(char *str)
{
#define MAX_MSG_SIZE 500
	
	static char szMsgBuf[MAX_MSG_SIZE];
	DWORD dwRes;
	DWORD error = GetLastError();
	
	if(error > 0xffff)
	{
		dwRes = LsaNtStatusToWinError(error);
		if(ERROR_MR_MID_NOT_FOUND != dwRes) error = dwRes;
	}

	dwRes = FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM, NULL, error, MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_US),
		szMsgBuf, MAX_MSG_SIZE, NULL);
	if (0 == dwRes)
		_snprintf(szMsgBuf, sizeof szMsgBuf, "Unknown error code:0x%8.8X", error);
	
	fprintf(stderr, "%s Error : (%d)%s\r\n", str, error, szMsgBuf);
}

