/***************************************************************************
 * Program: PWDUMP4 - dump winnt/2000 user/password hash remote or local for crack
 * 
 * Copyright (c) 2002, 2003 bingle, all rights reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author:  bingle@email.com.cn
 * File:    PwDump4.cpp
 * Purpose: PwDump4 Entry file, process command line options.
 * Date:    2002-1-20
 * 
 ***************************************************************************/

#include <stdio.h>
#include <windows.h>
#include <assert.h>
#include "PwDump4.h"

int main( int argc, char* argv[] )
{
	int ret;

	if(argc == 2 && memcmp(argv[1], SERVICE_TAG, sizeof(SERVICE_TAG)-1) == 0)
	{
		char *ptr = argv[1] + sizeof(SERVICE_TAG)-1;

		SERVICE_TABLE_ENTRY stbl[] = 
		{	//the service name is default or renamed ? I don't know
			{ ptr, (LPSERVICE_MAIN_FUNCTION)PWServiceMain },
			{ NULL, NULL }
		};

		fprintf( stderr, "try run as service...\n" );
	#ifdef _DEBUG
	//	DebugBreak(); // for debug the service
	#endif
		
		ret = StartServiceCtrlDispatcher( stbl );
	#ifdef _DEBUG 
		if(ret) fprintf( stderr, "StartServiceCtrlDispatcher failed, error: %u\n", GetLastError() );
	#endif
		return ret;
	}
	

    // notice to user
	fprintf( stderr, "\nPWDUMP4.02 dump winnt/2000 user/password hash remote or local for crack.\n" );
    fprintf( stderr, "   by bingle@email.com.cn\n" );
    fprintf( stderr, "This program is free software based on pwpump3 by Phil Staubs\n" );
    fprintf( stderr, "under the GNU General Public License Version 2.\n\n" );
    
	// if not a service, try regular program
	ret = ProcessCmdLine( argc, argv );
	if( ret != 0 )
    {
        fprintf( stderr, "Usage: PWDUMP4 [Target | /l] [/s:share] [/o:outputFile] [/u:userName]\n" );
        fprintf( stderr, "    [Target]  -- Target Computer's ip or name to work,\n" );
        fprintf( stderr, "    [/l]      -- works on local Computer.\n\n" );

		fprintf( stderr, "    [/s:share]        -- Share used to copy files instead of Admin$.\n" );
		fprintf( stderr, "    [/o:outputFile]   -- Result filename for output.\n" );
		fprintf( stderr, "    [/u:userName]     -- UserName used to connect, provide password later.\n" );
		fprintf( stderr, "    [/r[:newname]]    -- Rename the files to \'newname\' when copy to the target,          rename service name also, see FAQ for more.\n" );

		if( ret > 0 ) fprintf( stderr, "\t Invalid param: %s\n", argv[ret] );
		return 0;
    }

	//if neither provide target nor /l assume works on local,
	// if provide them 2 all, assume local too.
	if( !target && !bLocal )
	{
		bLocal = true;
		fprintf( stderr, "\t No target provide, assume works on local.\n" );
	}
	// params ok, try main dump function
	return PwDumpMain( argc, argv );
}

bool NeedHelp( int argc, char *argv[] )
{
	if( argc == 1 ) return true;
	if( argc > 2 ) return false;

	if( argv[1][0] != '/' && argv[1][0] != '-' ) return false;
	if( argv[1][1] != '?' && argv[1][1] != 'h') return false;
	if( argv[1][2] != '\0' ) return false;

	return true;
}

//ProcessCmdLine, return 0 if ok, < 0 if /-?, > 0 if the param invalid
int ProcessCmdLine( int argc, char *argv[] )
{
	if( NeedHelp(argc, argv) ) return -1;

	char *ptr;
	int i = 1;
	if( argv[1][0] != '/' && argv[1][0] != '-' ) 
	{
		target = argv[i];
		i++;
	}

	for( ; i < argc; i++ )
	{
		if( argv[i][0] != '/' && argv[i][0] != '-' ) return i;
			
		ptr = &argv[i][3];
		switch ( argv[i][1] )
		{
			case 'l':
			case 'L':
				bLocal = true;
				break;
				break;
			case 'o':
			case 'O':
				if( !argv[i][2] || !argv[i][3]) return i;
				outName = ptr;
				break;
			case 'r':
			case 'R':
				bRename = true;
				if( argv[i][2] && argv[i][3]) strncpy(newname, ptr, sizeof newname);
				break;
			case 's':
			case 'S':
				if( !argv[i][2] || !argv[i][3]) return i;
				share = ptr;
				break;
			case 'u':
			case 'U':
				if( !argv[i][2] || !argv[i][3]) return i;
				userName = ptr;
				break;
			default:
				return i;
		}
	}

	return 0;
}
