/*
 * Special hack for overriding the real main function for the john
 * the ripper program with our own that sets some C RTL features and
 * translates the path argv[0] to the unix syntax the real main expects.
 * Using this convoluted scheme minimizes source code changes needed to
 * john.c for building on OpenVMS.
 *
 * The john.c source file must be compiled with the qualifier
 * /define=("main(a,v)=vms_john_main(a,v)"), which comandeers the main()
 * function.
 *
 * Author:  David Jones
 * Date:    28-AUG-2011
 *
 * Copyright (c) 2011 by David L. Jones <jonesd/at/columbus.rr.com>, and
 * is hereby released to the general public under the following terms:
 *    Redistribution and use in source and binary forms, with or without
 *    modifications, are permitted.
 */
#include <stdio.h>
#include <string.h>
#include <unixlib.h>
#include <pthread.h>
/*
 * Declare table of features to be set with decc$set_feature().  Enable
 * file sharing default so we can 
 */
static struct {
    char *name;
    int orig_value;
    int value;
    int keep;		/* Apply to whole application */
} feature_list[] = {
    { "DECC$EFS_CHARSET", 0, 1, 1 },
    { "DECC$FILENAME_UNIX_NO_VERSION", 0, 1, 1 },
    { "DECC$FILE_SHARING", 0, 1, 1 },
    { (char *) 0, 0, 0, 0 }
};

int vms_john_main ( int argc, char **argv );
int main ( int argc, char **argv )
{
    char *orig_arg0, *translation, *ext, *rslash;
    int i, status;
    /*
     * Return immediately if it looks like we are in POSIX environment.
     */
    if ( (argc<1) || !argv[0] || argv[0][0] == '/' ) {
	return vms_john_main ( argc, argv );
    }
    orig_arg0 = argv[0];
    /*
     * Enable DECC features for extend filename support and file sharing
     * by default (to allow --status to read .rec file).
     */
    for ( i = 0; feature_list[i].name; i++ ) {
	feature_list[i].orig_value = decc$feature_set ( 
		feature_list[i].name, 1, feature_list[i].value );
    }
    /*
     * Convert argv[0] to unix syntax so john parses the path correctly,
     * then trim .exe from filename so program name can be identified.
     */
    translation = decc$translate_vms ( orig_arg0 );
    if ( !translation ) {
	printf ( "Failed to translate %s\n", orig_arg0 );
	return vms_john_main ( argc, argv );
    }
    argv[0] = strdup ( translation );

    rslash = strrchr ( argv[0], '/' );
    if ( rslash ) {
	ext = strchr ( rslash, '.' );
	if ( ext ) if ( strcasecmp ( ext, ".EXE" ) == 0 ) *ext = '\0';
    }
    /*
     * Revert any features that were temporarily set.
     */
    for ( i = 0; feature_list[i].name; i++ ) if ( !feature_list[i].keep ) {
	status = decc$feature_set ( 
		feature_list[i].name, 1, feature_list[i].orig_value );
    }
    return vms_john_main ( argc, argv );
}
