$!
$! Poor man's 'patch'.  parse [-]john_1.7.8.plugin.diff and appplies
$! + commands.  The patched files ONLY add lines (- commands aren't handled).
$! Assume current directory is [.src.vms] and files patched are in [.src]
$!
$! Parameters:
$!    P1    Name of diff file to process, default: [-]john_1.7.8.plugin.diff
$!    P2    default directory to operate on.
$!
$ input_file = f$parse(p1,"[-]john_1^.7^.8^.plugin.diff")
$ say = "write sys$output"
$ if f$search(input_file) .eqs. ""
$ then
$	say "Input file ''input_file' not found!"
$	exit
$ endif
$ current_default = f$environment("DEFAULT")
$ if P2 .nes. "" then set default 'P2'
$!
$ open/read inpf 'input_file'
$ on error then goto cleanup
$ on control_y then goto cleanup
$!
$! Main loop, look for +++, @@, and diff lines.
$!
$ state = 0
$ next_line:
$    read inpf line/end=inpf_eof
$    goto inpf_state_'state'
$ inpf_state_0:
$    line = f$edit(line,"compress")
$    if f$extract(0,3,line) .nes. "+++" then goto next_line
$    cur_source = f$element(1," ",line)
$    if f$element(0,"/",cur_source) .nes. "src"
$    then
$	say "Source file referred to in diff file in wrong place!"
$	goto cleanup
$    endif
$    state = 1
$    cur_sect = 0
$    cur_source = "[--.src]" + f$element(1,"/",cur_source)
$    goto next_line
$ inpf_state_1:			! look for @@ or diff
$    if f$extract(0,3,line) .eqs. "@@ "
$    then
$       range = f$edit(f$element(2,"@",line),"trim,compress")
$	s_range = f$element(0," ",range)
$	d_range = f$element(1," ",range)
$	d_count = f$element(1,",",d_range)
$	cur_sect = cur_sect + 1
$       change_'cur_sect'_count = 0
$       change_'cur_sect'_range = s_range
$	state = 2
$	say "(sect ''cur_sect', range ''range', d_range [''d_range'], count ''d_count')"
$	d_count = f$integer(d_count)
$    else
$!	say "sections terminate line: ", f$extract(0,20,line)
$        call patch_file 'cur_source'
$	state = 0
$    endif
$    goto next_line
$!
$ inpf_state_2:			! Save change_line
$    i = change_'cur_sect'_count
$    change_'cur_sect'_count = i+1
$    change_'cur_sect'_line_'i' = line
$    if ( f$extract(0,1,line) .nes. "-" ) then d_count = d_count - 1
$    if d_count .le. 0		! all lines read, change state
$    then
$        state = 1		! look for next change section.
$    endif
$    goto next_line
$ inpf_eof:
$ if state .eq. 1 then call patch_file 'cur_source'
$ cleanup:
$ set default 'current_default'
$ close inpf
$ exit
$!
$! Patch an individual source file using diff file information saved
$! if change_'x'_line_'i' DCL symbols.
$!
$ patch_file: SUBROUTINE
$    say "Patching source file ", P1, ", number of sections: ", cur_sect
$    pf_srcfile = f$parse(p1)	! supply all elements
$    if pf_srcfile .eqs. "" then say "Parse of ",p1, " failed"
$    if f$search(pf_srcfile,2) .eqs. ""
$    then
$       open srcf/read NL:/err=pf_srcerr	! file missing, read from null.
$    else
$       open srcf/read 'pf_srcfile'/err=pf_srcerr
$    endif
$    src_lnum = 0
$    pf_dstfile = f$parse("[-]",p1)
$    create 'pf_dstfile'
$    open/append dstf 'pf_dstfile'
$    on warning then goto pf_cleanup
$!
$!   Process sections
$!
$    say "Processing ", cur_sect, " sections"
$    sect = 0
$ pf_next_sect:
$    sect = sect + 1
$    if sect .gt. cur_sect then goto pf_nomore_sect
$    sect_size = change_'sect'_count
$    sect_range = change_'sect'_range
$    gosub patch_section
$    goto pf_next_sect
$!
$ pf_nomore_sect:
$    read srcf line/end=pf_src_eof
$    src_lnum = src_lnum + 1
$    write /symbol dstf line
$    goto pf_nomore_sect
$ pf_src_eof:
$    close srcf
$    close dstf
$    exit
$ pf_srcerr:
$    say "Error opening source file ", P1
$    exit
$ pf_cleanup:
$    close srcf
$    close dstf
$!
$!   Process single section
$!
$ patch_section:
$     s_range = f$element(0," ",sect_range)
$     start_line = -f$integer(f$element(0,",",s_range))
$     p_lnum = 0
$ ps_set_pos:
$     if src_lnum+1 .ge. start_line then goto ps_insert
$     read srcf line
$     src_lnum = src_lnum + 1
$     write dstf line
$     goto ps_set_pos
$!
$ ps_insert:
$     p_line = change_'sect'_line_'p_lnum'
$     p_lnum = p_lnum + 1
$!
$     p_data = f$extract(1,f$length(p_line)-1,p_line)
$     if f$extract(0,1,p_line) .eqs. "+"
$     then
$	  write/symbol dstf p_data
$     else
$         read srcf line
$         src_lnum = src_lnum + 1
$	  if line .nes. p_data then say "data mismatch, line ", src_lnum
$	  if line .nes. p_data then say "          expecting ", p_data
$	  if f$extract(0,1,p_line) .eqs. " " then write/symbol dstf p_data
$     endif
$     if p_lnum .lt. sect_size then goto ps_insert
$     return
$!
$ ENDSUBROUTINE
