!                                                                         
! MMS description file to build OpenVMS version john the ripper program,
! veraion 1.7.3.1
!
! Targets:
!    EXES (default)		All executables.
!
!    [-.run]john.exe		John the Ripper.
!
!    [-.run]uaf2john.exe        Utility to encode SYSUAF account/password
!				information in a format suitable for input to
!				John the Ripper.
!
! Macros:
!   HASH_SOURCE Used to replace uaf_hash.c component of uaf_encode.c with a 
!            variant file hash function (e.g. uaf_hash-EV6.c)
!   WARNLEVEL  (1-6) Used to force 'lint' compile with list files.
!   UAFOPT   DECC compiler qualifiers for uaf_encode compile.
!
! Date: 19-JUL-2009
! Revised: 20-AUG-2011          Update for 1.7.8
! Revised: 19-SEP-2011		Rename program, uaf_to_passwd --> uaf2john.
!
! Copyright (c) 2011 by David L. Jones <jonesd/at/columbus.rr.com>, and
! is hereby released to the general public under the following terms:
!   Redistribution and use in source and binary forms, with or without
!   modifications, are permitted.
!


common_objs = john.obj common.obj config.obj formats.obj memory.obj getopt.obj \
   bench.obj math.obj DES_std.obj DES_fmt.obj charset.obj \
   batch.obj external.obj inc.obj single.obj wordlist.obj crc32.obj \
   compiler.obj cracker.obj loader.obj rules.obj misc.obj lm_fmt.obj unafs.obj \
   des_bs.obj des_bs_b.obj idle.obj list.obj logger.obj options.obj params.obj \
   path.obj recovery.obj rpp.obj status.obj tty-vms.obj unique.obj \
   unshadow.obj md5_std.obj md5_fmt.obj bsdi_fmt.obj bf_fmt.obj bf_std.obj \
   afs_fmt.obj dummy.obj plugin.obj 

jumbo_objs = md5.obj md4.obj md5_gen_utils.obj unicode.obj \
   md5_gen_parser.obj md5_gen_preloads.obj md5_gen_fmt.obj undrop.obj \
   md5_go.obj md5_eq.obj mkv.obj genmkvpwd.obj mkvcalcproba.obj mkvlib.obj \
   zip2john.obj zip_fmt.obj gladman_hmac.obj gladman_pwd2key.obj ssh2john.obj \
   openssl_shim.exe pdf2john.obj pdfcrack.obj pdfcrack_common.obj pdf_fmt.obj \
   pdfparser.obj pdfcrack_rc4.obj pdfcrack_md5.obj rar2john.obj rar_fmt.obj \
   ssh_fmt.obj NETLM_fmt_plug.obj netsplitlm_fmt_plug.obj \
   compiled_plugins.options

.IFDEF HASH_SOURCE
HASH_SOURCE_QUAL = /define=(UAF_HASH_FUNCTION_SOURCE="""$(HASH_SOURCE)""")
.ELSE
HASH_SOURCE = uaf_hash.c
.ENDIF
.IFDEF UAFOPT
.ELSE
UAFOPT = /optimize=(inline=speed,tune=host)
.ENDIF
.IFDEF NOPTHREADS
NOPTHREADS_DEF = /define=(NOPTHREADS=1,_xMSC_VER=1)
.ENDIF
!
! Set default compiler flags for mixed cae name and name truncation to 31
! chars.  If macro WARNLEVEL defined, compile with heightened warnings
! and a listing file produced.
!
EXTRA_CFLAGS = $(CFLAGS) /NAMES=(AS_IS,SHORTENED)/include=([],[-])/nest=none
.IFDEF SHWPARM
.ELSE
SHWPARM = SOU
.ENDIF
.IFDEF WARNLEVEL
WARNEXCLUDE = nonulinit,unusedtop,longlongtype,INTCONSTSIGN,UNUSEDINCL,SUBSCRBOUNDS1
CFLAGS = $(EXTRA_CFLAGS) /optimize=level=0/warnings=(enable=LEVEL$(WARNLEVEL),\
  disable=($(WARNEXCLUDE)))/list/show=($(SHWPARM))
.ELSE
CFLAGS = $(EXTRA_CFLAGS)
.ENDIF
.IFDEF JUMBO
john_objs = $(common_objs) $(jumbo_objs)
jumbo_hs = fmt_externs.h fmt_registers.h
JOHN_OPTFILE = john-j7.opt/option,compiled_plugins.options
JOHN_OPT_DEP = john-j7.opt
.ELSE
john_objs = $(common_objs)
JOHN_OPTFILE = john.opt
JOHN_OPT_DEP = john.opt
.ENDIF

common_inc = [-]misc.h [-]memory.h [-]params.h [-]logger.h [-]formats.h [-]rpp.h
!
! Main target, executable images.
!
EXES : [--.run]john.exe [--.run]uaf2john.exe [--.run]vms_fmt.exe
   @ write sys$Output "executables ready"

[--.run]john.exe : $(john_objs) signals-mp.obj john.obj descrip.mms \
	prejohn.obj $(JOHN_OPT_DEP)
   link $(LINKFLAGS) $(JOHN_OPTFILE)/option/threads_enable=(upcall,multi)

[--.run]openvms_fmt_plug.exe : openvms_fmt_plug.obj openvms_fmt_plug.opt
   link $(LINKFLAGS) /share openvms_fmt_plug.opt/option

[--.run]vms_fmt.exe : vms_fmt.obj vms_fmt.opt vms_std-mp.obj uaf_encode.obj
   link $(LINKFLAGS) /share vms_fmt.opt/option

clean :
  delete *.obj;*
  purge *.lis

[--.run]uaf2john.exe : uaf2john.obj uaf_encode.obj
   link $(LINKFLAGS) uaf2john.obj,uaf_encode.obj

!
! mutlithreaded object modules
!
signals-mp.obj : signals-mp.c arch.h [-]misc.h [-]params.h [-]tty.h [-]config.h [-]bench.h

vms_std-mp.obj : vms_std-mp.c arch.h [-]common.h [-]logger.h vms_std.h uaf_encode.h
  cc $(CFLAGS) vms_std-mp.c

openvms_fmt_plug.obj : [-]openvms_fmt_plug.c arch.h [-]misc.h vms_std.h \
	[-]common.h [-]formats.h
  define/user vms sys$disk:[]
  cc $(CFLAGS) [-]openvms_fmt_plug.c

vms_fmt.obj : vms_fmt.c vms_std.h
  cc $(CFLAGS) vms_fmt.c
!
! Objects from standard files modified for VMS.
!
john.obj : [-]john.c arch.h $(common_inc) [-]path.h [-]list.h [-]tty.h \
	[-]signals.h [-]common.h [-]loader.h [-]logger.h [-]status.h \
	[-]options.h [-]config.h [-]bench.h [-]charset.h [-]single.h \
	[-]wordlist.h [-]inc.h [-]external.h [-]batch.h [-]plugin.h $(jumbo_hs)
  cc $(CFLAGS) [-]john.c /nooptim/define=("main(a,v)=vms_john_main(a,v)",_xMSC_VER=1)

arch.h : alpha-vms.h
   copy alpha-vms.h arch.h

uaf2john.obj : uaf2john.c uaf_encode.h uaf_raw.h

uaf_encode.obj : uaf_encode.c $(HASH_SOURCE) uaf_encode.h arch.h uaf_raw.h
    cc $(UAFOPT) $(CFLAGS) uaf_encode.c $(HASH_SOURCE_QUAL)

tty-vms.obj : tty-vms.c [-]tty.h
!
! Header files generated by script from name.
!
fmt_externs.h : compile_time_plugin.com
    @compile_time_plugin.com externs

fmt_registers.h : compile_time_plugin.com
    @compile_time_plugin.com registers

compiled_plugins.options : compile_time_plugin.com
    @compile_time_plugin.com options

!des_bs_n.c : [-]nonstd.c
!   @ editor="edit"
!   @ editor/edt/command=des_bs_n.edt/nojournal/nooutput [-]nonstd.c

!
! Object files from standard john the ripper 1.7.3.1 files
!

common.obj : [-]common.c arch.h [-]common.h
   CC $(CFLAGS) [-]common.c

config.obj : [-]config.c [-]misc.h [-]params.h [-]path.h [-]memory.h [-]config.h

formats.obj : [-]formats.c [-]params.h [-]formats.h

memory.obj : [-]memory.c arch.h [-]misc.h [-]memory.h

getopt.obj : [-]getopt.c [-]misc.h [-]memory.h [-]list.h [-]getopt.h

bench.obj : [-]bench.c [-]times.h arch.h $(common_inc) [-]math.h [-]signals.h \
	[-]bench.h
    CC $(CFLAGS) /define=(_XOPEN_SOURCE_EXTENDED) [-]bench.c

math.obj : [-]math.c arch.h [-]math.h

DES_std.obj : [-]DES_std.c arch.h [-]common.h [-]DES_std.h

DES_fmt.obj : [-]DES_fmt.c arch.h [-]DES_std.h [-]common.h [-]formats.h [-]des_bs.h

charset.obj : [-]charset.c [-]params.h [-]loader.h

batch.obj :  [-]batch.c [-]params.h [-]signals.h [-]loader.h [-]status.h [-]config.h\
	 [-]single.h [-]wordlist.h [-]inc.h

external.obj : [-]external.c [-]misc.h [-]params.h [-]signals.h [-]compiler.h \
	[-]loader.h [-]logger.h [-]status.h [-]recovery.h [-]config.h \
	[-]cracker.h [-]external.h

inc.obj : [-]inc.c [-]loader.h

single.obj : [-]single.c [-]misc.h [-]params.h [-]memory.h [-]signals.h [-]loader.h \
	[-]logger.h [-]status.h [-]recovery.h [-]rpp.h [-]rules.h [-]external.h \
	[-]cracker.h

wordlist.obj : [-]wordlist.c [-]misc.h [-]math.h [-]params.h [-]path.h \
	[-]signals.h [-]loader.h [-]logger.h [-]status.h [-]recovery.h \
	[-]rpp.h [-]rules.h [-]external.h

crc32.obj : [-]crc32.c [-]memory.h [-]crc32.h

compiler.obj : [-]compiler.c arch.h [-]params.h [-]memory.h [-]compiler.h

cracker.obj : [-]cracker.c $(common_inc) arch.h [-]math.h [-]signals.h [-]idle.h \
	[-]loader.h [-]status.h [-]recovery.h

loader.obj : [-]loader.c arch.h $(common_inc) [-]path.h [-]list.h\
	 [-]signals.h [-]loader.h

rules.obj : [-]rules.c arch.h $(common_inc) [-]rules.h

misc.obj : [-]misc.c [-]logger.h

lm_fmt.obj : [-]lm_fmt.c arch.h [-]misc.h [-]memory.h [-]DES_bs.h [-]common.h \
	[-]formats.h
  cc $(CFLAGS) [-]lm_fmt.c /nooptimize

des_bs.obj : [-]des_bs.c arch.h [-]common.h [-]DES_std.h [-]DES_bs.h

des_bs_b.obj : [-]des_bs_b.c arch.h

idle.obj : [-]idle.c [-]params.h [-]config.h [-]options.h [-]signals.h [-]bench.h
    CC $(CFLAGS) /define=(_XOPEN_SOURCE_EXTENDED) [-]idle.c

list.obj : [-]list.c [-]memory.h [-]list.h

prejohn.obj : prejohn.c

logger.obj : [-]logger.c arch.h [-]misc.h [-]params.h [-]path.h [-]memory.h \
	[-]status.h [-]config.h
    CC $(CFLAGS) /define=(_XOPEN_SOURCE_EXTENDED) [-]logger.c

options.obj : [-]options.c $(common_inc) arch.h [-]misc.h [-]params.h \
	[-]memory.h [-]list.h [-]loader.h [-]logger.h [-]status.h [-]options.h\
	[-]recovery.h

params.obj : [-]params.c [-]params.h

path.obj : [-]path.c [-]misc.h [-]params.h [-]memory.h [-]path.h

recovery.obj : [-]recovery.c $(common_inc) arch.h [-]path.h [-]options.h [-]loader.h \
	[-]status.h [-]recovery.h
    CC $(CFLAGS) /define=(_XOPEN_SOURCE_EXTENDED) [-]recovery.c

rpp.obj : [-]rpp.c arch.h [-]params.h [-]config.h [-]rpp.h

status.obj : [-]status.c [-]misc.h [-]math.h [-]params.h [-]cracker.h \
	[-]options.h [-]status.h [-]bench.h

unique.obj : [-]unique.c $(common_inc)

unshadow.obj : [-]unshadow.c [-]misc.h [-]params.h [-]memory.h

unafs.obj : [-]unafs.c [-]misc.h

md5_std.obj : [-]md5_std.c [-]md5_std.h arch.h [-]common.h

md5_fmt.obj : [-]md5_fmt.c [-]md5_std.h arch.h [-]misc.h [-]common.h [-]formats.h

bsdi_fmt.obj : [-]bsdi_fmt.c arch.h [-]misc.h [-]des_std.h [-]common.h [-]formats.h

bf_std.obj : [-]bf_std.c [-]bf_std.h arch.h [-]common.h
  cc $(CFLAGS) [-]bf_std.c /opt=level=1

bf_fmt.obj : [-]bf_fmt.c [-]bf_std.h arch.h [-]misc.h [-]common.h [-]formats.h

afs_fmt.obj : [-]afs_fmt.c arch.h [-]misc.h [-]params.h [-]des_std.h [-]common.h \
		[-]formats.h

unicode.obj : [-]unicode.c [-]unicode.h

signals.obj : [-]signals.c arch.h [-]misc.h [-]params.h [-]tty.h [-]config.h [-]bench.h

dummy.obj : [-]dummy.c [-]common.h [-]formats.h

md5.obj : [-]md5.c

md5_gen_utils.obj : [-]md5_gen_utils.c

md5_gen_fmt.obj : [-]md5_gen_fmt.c

md5_gen_preloads.obj : [-]md5_gen_preloads.c

md5_gen_parser.obj : [-]md5_gen_parser.c

md5_go.obj : [-]md5_go.c

md5_eq.obj : [-]md5_eq.c

md4.obj : [-]md4.c

mkv.obj : [-]mkv.c [-]mkv.h

genmkvpwd.obj : [-]genmkvpwd.c [-]mkv.h

mkvcalcproba.obj : [-]mkvcalcproba.c [-]mkv.h

mkvlib.obj : [-]mkvlib.c [-]mkv.h

plugin.obj : [-]plugin.c [-]plugin.h [-]list.h [-]formats.h
  cc $(CFLAGS) [-]plugin.c /define=HAVE_DL=1

undrop.obj : [-]undrop.c

zip2john.obj : [-]zip2john.c

zip_fmt.obj : [-]zip_fmt.c [-]gladman_fileenc.h

gladman_hmac.obj : [-]gladman_hmac.c [-]gladman_fileenc.h

gladman_pwd2key.obj : [-]gladman_pwd2key.c [-]gladman_fileenc.h

ssh2john.obj : [-]ssh2john.c

openssl_shim.exe : openssl_shim.opt
    link /share openssl_shim.opt/option/exe=openssl_shim.exe

pdf2john.obj : [-]pdf2john.c [-]pdfparser.h [-]pdfcrack.h

pdfcrack.obj : [-]pdfcrack.c [-]pdfcrack.h

pdfcrack_common.obj : [-]pdfcrack_common.c [-]pdfcrack_common.h

pdfcrack_md5.obj : [-]pdfcrack_md5.c [-]pdfcrack_md5.h

pdfcrack_rc4.obj : [-]pdfcrack_rc4.c [-]pdfcrack_rc4.h

pdfprarser.obj : [-]pdfparser.c [-]pdfparser.h

pdf_fmt.obj : [-]pdf_fmt.c [-]pdfparser.h [-]pdfcrack.h

rar2john.obj : [-]rar2john.c

rar_fmt.obj : [-]rar_fmt.c

ssh_fmt.obj : [-]ssh_fmt.c

NETLM_fmt_plug.obj : [-]netlm_fmt_plug.c

netsplitlm_fmt_plug.obj : [-]netsplitlm_fmt_plug.c
