/*
 * This file is part of John the Ripper password cracker,
 * Copyright (c) 1996-2001 by Solar Designer
 *
 * Copyright (c) 2011 by David L. Jones <jonesd/at/columbus.rr.com>, and
 * is hereby released to the general public under the following terms:
 *    Redistribution and use in source and binary forms, with or without
 *    modifications, are permitted.
 */

/*
 * Architecture specific parameters for OpenvVMS (alpha), using x86 as
 * template (little endian).  Build procedure copies to arch.h.
 */

#ifndef _JOHN_ARCH_H
#define _JOHN_ARCH_H
#if !defined(HAVE_PTHREADS) && !defined(NOPTHREADS)
#define HAVE_PTHREADS 1
#endif
#ifndef HAVE_DL			/* dlopen() support */
#define HAVE_DL 1
#endif

#define ARCH_WORD			long
#define ARCH_SIZE			4
#define ARCH_BITS			32
#define ARCH_BITS_LOG			5
#define ARCH_BITS_STR			"32"
#define ARCH_LITTLE_ENDIAN		1
#define ARCH_INT_GT_32			0
#define ARCH_ALLOWS_UNALIGNED		1
#define ARCH_INDEX(x)			((unsigned int)(unsigned char)(x))

#if defined(__CYGWIN32__) || defined(__BEOS__)
#define OS_TIMER			0
#else
#define OS_TIMER			1
#endif
#define OS_FLOCK			1

#define CPU_DETECT			0
#define CPU_REQ				0

#define DES_ASM				0
#define DES_128K			0
#define DES_X2				0
#define DES_MASK			1
#define DES_SCALE			0
#define DES_EXTB			0
#define DES_COPY			1
#define DES_BS_ASM			0
#define DES_BS				0
#define DES_BS_VECTOR			0
#define DES_BS_EXPAND			0

#define MD5_ASM				0
#define MD5_X2				0
#define MD5_IMM				1

#define BF_ASM				0
#define BF_SCALE			1
#define BF_X2				0

#endif
#define SA_RESTART 1
