#include <stdio.h>

#define GCC_X86_ID			"gcc/x86"

#define GCC_X86_SP \
	"\x68\x00\x00\x00\x08" \
	"\x68\xfe\x00\x00\x00" \
	"\xff\x30\x00" \
	"\xe8"

#define GCC_X86_SM \
	"\xff\x00\x00\x00\xff" \
	"\xff\xff\xff\xff\xff" \
	"\xff\x38\x00" \
	"\xff"

#define GCC_X86_TP \
	"\x00\x00\x00\x00\x00" \
	"\x00\x00\x00\x00\x00" \
	"\x00\x00\x00" \
	"\xb8"

#define GCC_X86_TM \
	"\xff\xff\xff\xff\xff" \
	"\xff\xff\xff\xff\xff" \
	"\xff\xff\xff" \
	"\x00"

#define GCC_X86_PS			14

#define WIN32_NAVIGATOR_ID		"Win32/Navigator"

#define WIN32_NAVIGATOR_SP \
	"\x68\x00\x00\x00\x00" \
	"\x8b\x40\x00" \
	"\x68\xfe\x00\x00\x00" \
	"\x50" \
	"\xe8"

#define WIN32_NAVIGATOR_SM \
	"\xff\x00\x00\x00\xff" \
	"\xff\xc0\x00" \
	"\xff\xff\xff\xff\xff" \
	"\xf8" \
	"\xff"

#define WIN32_NAVIGATOR_TP \
	"\x00\x00\x00\x00\x00" \
	"\x00\x00\x00" \
	"\x00\x00\x00\x00\x00" \
	"\x00" \
	"\xb8"

#define WIN32_NAVIGATOR_TM \
	"\xff\xff\xff\xff\xff" \
	"\xff\xff\xff" \
	"\xff\xff\xff\xff\xff" \
	"\xff" \
	"\x00"

#define WIN32_NAVIGATOR_PS		15

#define WIN32_COMMUNICATOR_ID		"Win32/Communicator"

#define WIN32_COMMUNICATOR_SP \
	"\x68\x00\x00\x00\x00" \
	"\x68\xfe\x00\x00\x00" \
	"\xff\x30\x00" \
	"\xe8"

#define WIN32_COMMUNICATOR_SM \
	"\xff\x00\x00\x00\xff" \
	"\xff\xff\xff\xff\xff" \
	"\xff\x38\x00" \
	"\xff"

#define WIN32_COMMUNICATOR_TP \
	"\x00\x00\x00\x00\x00" \
	"\x00\x00\x00\x00\x00" \
	"\x00\x00\x00" \
	"\xb8"

#define WIN32_COMMUNICATOR_TM \
	"\xff\xff\xff\xff\xff" \
	"\xff\xff\xff\xff\xff" \
	"\xff\xff\xff" \
	"\x00"

#define WIN32_COMMUNICATOR_PS		14

#define ALPHA_ID			"Alpha"

#define ALPHA_SP \
	"\x11\xd4\xff\x43" \
	"\x00\x00\x40\xd3"

#define ALPHA_SM \
	"\xff\xff\xff\xfb" \
	"\x00\x00\xe0\xff"

#define ALPHA_TP \
	"\x00\x00\x00\x00" \
	"\x00\x00\x00\x00"

#define ALPHA_TM \
	"\xff\xff\xff\xff" \
	"\x00\x00\xe0\xff"

#define ALPHA_PS			8

#define MAX_PS				15

static struct {
	char *id;
	char *sp, *sm;
	char *tp, *tm;
	int ps;
} patterns[] = {
	{
		GCC_X86_ID,
		GCC_X86_SP, GCC_X86_SM,
		GCC_X86_TP, GCC_X86_TM,
		GCC_X86_PS
	}, {
		WIN32_NAVIGATOR_ID,
		WIN32_NAVIGATOR_SP, WIN32_NAVIGATOR_SM,
		WIN32_NAVIGATOR_TP, WIN32_NAVIGATOR_TM,
		WIN32_NAVIGATOR_PS
	}, {
		WIN32_COMMUNICATOR_ID,
		WIN32_COMMUNICATOR_SP, WIN32_COMMUNICATOR_SM,
		WIN32_COMMUNICATOR_TP, WIN32_COMMUNICATOR_TM,
		WIN32_COMMUNICATOR_PS
	}, {
		ALPHA_ID,
		ALPHA_SP, ALPHA_SM,
		ALPHA_TP, ALPHA_TM,
		ALPHA_PS
	}, {NULL}
};

static char buffer[MAX_PS], saved[MAX_PS];
static int where;
static FILE *file;

static int match(char *source, char *mask, int size)
{
	int i, j;

	for (i = where + 1, j = 0; j < size; i++, j++) {
		if (i >= MAX_PS) i = 0;
		if ((buffer[i] & mask[j]) != source[j])
			return 0;
	}

	return 1;
}

static int match_all()
{
	int i;

	for (i = 0; patterns[i].id; i++)
	if (match(patterns[i].sp, patterns[i].sm, patterns[i].ps))
		return i;

	return -1;
}

static void save(int size)
{
	int i, j;

	for (i = where + 1, j = 0; j < size; i++, j++) {
		if (i >= MAX_PS) i = 0;
		saved[j] = buffer[i];
	}
}

static int patch(char *target, char *mask, int size)
{
	int i;
	char c;

	for (i = 0; i < size; i++) {
		c = (saved[i] & mask[i]) ^ target[i];
		if (putc(c, file) == EOF) return -1;
	}

	return 0;
}

int main(int argc, char **argv)
{
	long offset, found;
	int which;
	int c;

	if (argc != 2) {
		puts("Provide a filename, please");
		return 1;
	}

	if (!(file = fopen(argv[1], "rb+"))) {
		perror("fopen");
		return 1;
	}

	where = 0;
	offset = 0;
	found = -1;
	which = -1;

	while ((c = getc(file)) != EOF) {
		buffer[where] = c;

		if (++offset >= MAX_PS)
		if (match_all() >= 0) {
			if (found >= 0) {
				printf("Extra pattern match at 0x%lx\n",
					offset - MAX_PS);
				return 1;
			}

			found = offset - MAX_PS;
			which = match_all();
			save(patterns[which].ps);

			printf("Pattern found at 0x%lx (%s)\n",
				found, patterns[which].id);
		}

		if (++where >= MAX_PS) where = 0;
	}

	if (ferror(file)) {
		perror("getc");
		return 1;
	}

	if (found < 0 || which < 0) {
		puts("Pattern not found");
		return 1;
	}

	if (fseek(file, found, SEEK_SET)) {
		perror("fseek");
		return 1;
	}

	if (patch(patterns[which].tp, patterns[which].tm,
	    patterns[which].ps)) {
		perror("putc");
		return 1;
	}

	if (fclose(file)) {
		perror("fclose");
		return 1;
	}

	puts("Patched successfully");

	return 0;
}
