# Passwdqc-js
## About

The [passwdqc](http://openwall.com/passwdqc/) is the brilliant password quality checker library made by [Openwall](http://openwall.com/). **Passwdqc-js** is a JavaScript port of [passwdqc](http://openwall.com/passwdqc/), made by [Parallels](https://www.parallels.com/). **Passwdqc-js** supports AMD and NodeJS/CommonJS module format. So it runs on both client and server.

## Compatibilty with Passwdqc

Passwdqc-js was tested for compatibility with original passwdqc. We used following password databases in order to guarantee that both accept nearly the same subset of passwords:

* 14M unique RockYou passwords from 2009 leak (99.99% match with passwdqc)
* 10K random 10-character symbolic passwords (100% match with passwdqc)
* 10K random pass phrases, generated by passwdqc/pwqgen (100% match with passwdqc)

## Usage
Use `passwdqc.check(newpass, [oldpass], [login], [gecos], [params])` function to check password quality.

**Parameters**

* **newpass**: password to check
* **oldpass**: old password to check if new password is based on it
* **login**: user's login name to check that password is not based on it
* **gecos**: any other personal information to check
* **params**: custom parameters for passwdqc algorithm, [see](http://www.openwall.com/passwdqc/README.shtml)

**Return value**

* Empty string if password is considered good;
* The reason why password is considered weak, otherwise.

### Examples
**NodeJS**
```js
var passwdqc = require('passwdqc');

var rv = passwdqc.check(password, old_password);

if (!rv) {
	// Password is of good quality
	// ...
} else {
	// The "rv" now contains reason why password considered weak
}
```

**Client-Side**
```js
// Declare security policy
var lowParams	 = { min: [6,  6,  6, 6, 6], max: 40, passphrase_words: 3, match_length: 4, similar_deny: 1, random_bits: 47, flags: 3, retry: 3 },
	mediumParams = { min: [8,  8,  8, 7, 6], max: 40, passphrase_words: 3, match_length: 4, similar_deny: 1, random_bits: 47, flags: 3, retry: 3 };

// Checking value
function check(val){
    if(val.length == 0) return 0;
    if(!passwdqc_check(val)) return 4;
    if(!passwdqc_check(val, undefined, undefined, undefined, mediumParams)) return 3;
    if(!passwdqc_check(val, undefined, undefined, undefined, lowParams)) return 2;
    return 1;
}
```
[Live full example](http://jsfiddle.net/burashka/mdhs4/2/embedded/result/)

### Distribution
**NPM**
```shell
npm install passwdqc
```

**Bower**
More info about [Bower](http://bower.io/)
```shell
bower install passwdqc
```

## TODO
* More examples
* Random password/passphrase generator
